//############################################################################//
//             Copyright (c) 2006, by Deluxe-Menu.com
//             Deluxe Tuner script
//             http://deluxe-menu.com
//             Programming by Shakhmatov Nik
//             E-mail: cs@deluxe-menu.com
//############################################################################//


var itemParamsCnt = 8;    // amount of used item parameters


//############################################################################//
//  Functions for item params
//############################################################################//

var setFromTuner = false;

var hints = [
    ['trText',      'Item text.\nItem with \'-\' (minus) text is separator.\n\nTo create images-based item set this value to empty and use item icon fields to assign images.'],
    ['trLink',      'Item link (URL).\nYou can also assign Javascript code to item using prefix \'javascript:\', for example:\n\n\javascript:alert(\'Hello!\')'],
    ['trTarget',    'Item target.\nYou can select standard target value or set your own value, for example, frame name.\n\nIf target is \'_\' item is disabled.'],
    ['trTip',       'Hint message.'],
    ['trIcon',      'Normal icon.\n\nIf item text is empty, the item is an image-based one and the field is used as item normal image.'],
    ['trIconOver',  'Mouseover icon.\n\nIf item text is empty, the item is an image-based one and the field is used as item mouseover image.'],
    ['trItemStyle', 'Individual item style.'],
    ['trSmStyle',   'Individual submenu style.\nThis style can be assigned to the first item in submenu.'],
    ['trAJAX',      'Javascript filename that contains menuItems for the submenu that will be loaded from server.']
];

window.onload = assignHints;

function assignHints()
{
  for (var i=0; i<hints.length; i++)
      document.getElementById(hints[i][0]).title = hints[i][1];
}


function dm_setItemParams(iText, iLink, iIcon, iIconOver, iTip, iTarget, iStyle, iSmStyle, iAJAX)
// Sets item parameters to objects
{
  setFromTuner = true;
  with (document)
  {
      getElementById('itemText_id'  ).value = iText;
      getElementById('itemLink_id'  ).value = iLink;
      getElementById('iconNormal_id').value = iIcon;
      getElementById('iconOver_id'  ).value = iIconOver;
      getElementById('itemTip_id'   ).value = iTip;
      dm_setParam_setadd('itemTarget', iTarget);
      getElementById('itemStyle_id'   ).selectedIndex = (iStyle!=='') ? iStyle : -1;
      getElementById('submenuStyle_id').selectedIndex = (iSmStyle!=='')  ? iSmStyle : -1;
      getElementById('AJAX_id'  ).value = iAJAX;
  }
  setFromTuner = false;
}


function dm_getItemParam(paramInd)
// Returns specified item param from object
{
  with (document)
  {
      switch (paramInd)
      {
        case 0: return getElementById('itemText_id').value;
        case 1: return getElementById('itemLink_id').value;
        case 2: return getElementById('iconNormal_id').value;
        case 3: return getElementById('iconOver_id').value;
        case 4: return getElementById('itemTip_id').value;
        case 5: return dm_getParam_setadd('itemTarget');
        case 6: return getElementById('itemStyle_id').selectedIndex;
        case 7: return getElementById('submenuStyle_id').selectedIndex;
        case 8: return getElementById('AJAX_id').value;

        default: return '';
      }
      }
}

